*** Do-fil til kapittel 2
*** Data for 9 personer er tastet inn og lagret
* Variabelnavn endres
rename var1 idnr
rename var2 kvinne
rename var3 alder
rename var4 utdanning
* Variabeletiketter legges til
label variable idnr "Løpenummer"
label variable kvinne "Kjønn"
label variable var3 "Alder i år"
label variable utdanning "Utdanningsnivå"
label define kvinne 0 "Mann" 1 "Kvinne"
label define utdanning 1 "Lav" 2 "Middels" 3 "Høy"
label values kvinne kvinne
label values utdanning utdanning
*****************************************
*** Omkodinger av alder, klasse og utdanning
use "https://nedlasting.fagbokforlaget.no/stata/abu89.dta", clear
recode age (16/32 = 1 16-32)(33/44 = 2 33-44)(45/74 = 3 45-74), generate(age3)
generate age10 = age/10
label data "Alder i 10-år, fra age"
tabu klasse89
recode klasse89 (1 2=1 Serviceklasse)(3=2 Rutinefunksjonærer) ///
  (4 5=3 Arbeiderklasse), gen(klasse89_3)
tabu klasse89_3
tabu klasse89 klasse89_3  
recode klasse89 (1 2=1 Service)(3 4 5=2 Arbeider), gen(service)
tabu service
recode ed (0=1 Ungd)(1=2 VG1)(3=3 VG2)(5/11=4 Univ),generate(utdniv4)
label variable utdniv "Utdanningsnivå 4 verdier"
recode ed (0=1 Ungd)(1 3=2 VG)(5/11=4 Univ),generate(utdniv3)
label variable utdniv3 "Utdanningsnivå 3 verdier"
*** Missing values
misstable summarize, all
egen missing = rowmiss (time89 klasse89)
tabu missing
**********************************
* European Social Survey 2014, tematiske filer
* Tematisk fil om politikk
*******
* Datafil: ESS7NO.dta lastes ned fra http://www.europeansocialsurvey.org/data/
* I tillegg til selve datafilen følger do.filen "ESS_miss.do" med.
* Åpne både ESS7NO.dta
* Merk at stien til filen må tilpasses at filen er på din pc.
* Merk også at Stata ikke oppfatter store og små bokstaver som like 
use "c:\Users\kristenr\Dropbox\Statabok\Data\ESS7NO.dta", clear
* åpne ESS_miss.do, merk alle kommandoene som definerer verdier 
* for manglende informasjon korrekt
* Filen lagres på nytt med samme navn med ",replace" til slutt
save "C:\Users\kristenr\Dropbox\Statabok\Data\ESS7NO.dta", replace
* Velger variabler med "keep" og lagrer i en ny fil.
* Merk at "///" er symbolet for at en kommando fortsetter på neste linje
keep  name essround edition proddate idno cntry ///   Id-varabler 
    ppltrst pplfair pplhlp ///  Sosial tillit 
	trstprl trstlgl trstplc trstplt trstprt trstep trstun /// Politisk tillit
	psppsgv actrolg  psppipl cptppol ptcpplt etapapl /// Pol effektivitet
	vote prtvtbno lrscale ///  stemte, parti, venstre - høyre skala
	contplt wrkprty wrkorg badge sgnptit pbldmn bctprd ///  Pol aktivitet 
    gincdif freehms ///  Stridsstørsmål: homofile, inntektsforskjeller
    yrbrn gndr eduyrs eisced edlvdno hinctnta hincfel /// bakgrunn 
	dweight  /* design vekt */
describe, short 
* Filen lagres til senere bruk, husk å endre sitien i kommandoen som følger 
save "c:\Users\kristenr\Dropbox\Statabok\Data\ESS7NO_Pol.dta"  
* Merk at store og små bokstaver oppfattes som identiske i filenavn
* Hvis du ikke har gjennomført dette trinnet, kan filen åpnes slik:
use "https://nedlasting.fagbokforlaget.no/stata/ESS7NO_Pol.dta", clear
* Klargjøre bakgrunnsvariabler i politikkfilen
* Lage kvinne fra gndr med generate, legge til variabel- og verdietiketter
generate kvinne = gndr - 1
label variable kvinne "Kjønn, fra gndr"
label define kvinne 0 "Mann" 1 "Kvinne"
label values kvinne kvinne
tabu kvinne   /* Her vises etiketter, men ikke tallkodene */
tabu kvinne, nolabel  /* Her vises bare tallkodene */ 
* Alternativ med bruk av recode
* recode gndr (1=0 Mann)(2=1 Kvinne), generate(kvinne)
* Lage alder fra yrbrn - fødselsår + legge til variabeletikett
generate alder = 2014 - yrbrn
label variable alder "Alder i år, fra yrbrn"
summarize alder
** Alder i fire kategorier
tabstat alder, statistics(p25 p50 p75)
*** Alder i fire kategorier
recode alder (15/30 = 1 15-30)(31/49=2 31-49)(50/60=3 50-60)  ///
   (61/105=4 61+), generate(alder4)
label variable alder4 "Alder i 4 kategorier"
******* Omkodinger av utdanning
tabu edlvdno, missing
recode edlvdno (1/4=1 "Ungdomsskole")(5/8=2 "Videregående")(9/11=3 "Bachelor") ///
  (12/13=4 "Master")(.b .c 5555.=.), generate(utdniv)
label variable utdniv "Utdanningsnivå, fra edlvdno"
tabu utdniv, missing
* Sjekke urimelig høye verdier av eduyrs
list idno alder eduyrs edlvdno if eduyrs>24 & eduyrs<40, table nolabel
list idno alder eduyrs edlvdno if eduyrs>24 & eduyrs<40, table
***** Omkoding av holdning til homofile, freehms
recode freehms (1=1 "Svært enig")(2=2 "Enig")(3/5=3 "Uenig") ///
  (.b .c=.), generate(homlev)
label variable homlev "Holdning til homofile, fra freehms"
tabulate homlev
**** Omkoding av holdning til inntektsforskjeller, gincdif
* Her brukes den automatisk genererte variabeletiketten
recode gincdif (1=1 "Svært enig")(2=2 "Enig") ///
  (3=3 "Verken enig eller uenig")(4 5=4 "Uenig"), generate(intulik)
tabu gincdif intulik
*** Filen med omkodinger lagres
save "c:\Users\kristenr\Dropbox\Statabok\Data\ESS7NO_Pol2.dta", replace 
* Denne filen kan også lastes ned fra: https://stata.portfolio.no/ 
*********************************************************************
* Tematisk fil om helse Datafil: ESS7NO.dta
******************
* Velge variabler med "keep" og lagre i en ny fil
use "c:\Users\kristenr\Dropbox\Statabok\Data\ESS7NO.dta", clear
keep name essround edition proddate idno cntry ///  Id-varabler
  happy health ///   /* Lykke, generell helse */
  fltdpr flteeff slprl wrhpp fltlnl enjlf fltsd cldgng ///  Depresjpon 
  etfruit eatveg dosprt cgtsmke cgtsday alcfreq ///   Livsstil 
  sclmeet inprdsc sclact icpart2 ///   Sosial støtte 
  height weight ///   Høyde og vekt 
  yrbrn gndr eduyrs eisced edlvdno hinctnta hincfel /// Bakgrunn 
  dweight  /* Designvekt */
describe, short
save "c:\Users\kristenr\Dropbox\Statabok\Data\ESS7NO_Helse.dta", replace
* Denne filen kan også lastes ned fra: https://stata.portfolio.no/ 
* Den kan også åpnes fra Stata med denne kommandoen:
use "https://nedlasting.fagbokforlaget.no/stata/ESS7NO_Helse.dta", clear
*
*** Bakgrunnsvariabler som i politikkfilen ***********
generate kvinne = gndr - 1
label variable kvinne "Kjønn, fra gndr"
label define kvinne 0 "Mann" 1 "Kvinne"
label values kvinne kvinne
* Lage alder fra yrbrn - fødselsår + legge til variabeletikett
generate alder = 2014 - yrbrn
label variable alder "Alder i år, fra yrbrn"
** Alder i fire kategorier
recode alder (15/30 = 1 15-30)(31/49=2 31-49)(50/60=3 50-60)  ///
   (61/105=4 61+), generate(alder4)
label variable alder4 "Alder i 4 kategorier"
******* Omkodinger av utdanning
recode edlvdno (1/4=1 "Ungdomsskole")(5/8=2 "Videregående")(9/11=3 "Bachelor") ///
  (12/13=4 "Master")(.b .c 5555.=.), generate(utdniv)
label variable utdniv "Utdanningsnivå, fra edlvdno"
************************
****** Klargjøre noen helsevariabler.
** Happy - lykke
recode happy (0/6=1 "Ulykkelig")(7=2)(8=3)(9=4)  /// 
  (10=5 "Svært lykkelig"), generate(lykke)
  tabu happy lykke
** Selvrapportert vurdering av helse 
recode health (1=1 "Svært god")(2=2 "God")(3=3 "Middels") ///
  (4 5=4 "Dårlig"), generate(helse)
recode health (1 2=0 "God")(3/5=1 "Dårlig"), generate(dhelse)
tab helse dhelse
* Snu verdiene på en variabel
generate cgtsmke_r = 6 - cgtsmke
generate happy_r = 10 - happy
tab1 cgtsmke_r happy_r
**** Kroppsmasseindeks BMI 
generate kmi = round(weight/( height/100)^2)
summarize height weight kmi
list kmi height weight in 1/5
save "c:\Users\kristenr\Dropbox\Statabok\Data\ESS7NO_Helse2.dta"  
* Denne filen kan også lastes ned fra: https://stata.portfolio.no/ 
* Den kan også åpnes fra Stata med denne kommandoen:
use "https://nedlasting.fagbokforlaget.no/stata/ESS7NO_Helse2.dta", clear


